const startBtn = document.getElementById("start-button");
const stopBtn = document.getElementById("stop-button");
const hours = document.getElementById("hours-input");
const minutes = document.getElementById("minutes-input");
const seconds = document.getElementById("seconds-input");
const display = document.getElementById("display")
const ending = document.getElementById("ending")

let totalSeconds;
let timerInterval;

startBtn.addEventListener("click", () => {
    clearInterval(timerInterval);
    let h = Number(hours.value);
    let m = Number(minutes.value);
    let s = Number(seconds.value);

    totalSeconds = (h *  3600) + (m * 60) + s;

    if (totalSeconds <= 0)
        return;

    timerInterval = setInterval(() => {
        totalSeconds--;
    
//calculate the stuff inside the interval so they update every second
    let hrs = Math.floor(totalSeconds/ 3600);
    let mins = Math.floor((totalSeconds % 3600) / 60);
    let secs = totalSeconds % 60;

    display.textContent = `${String(hrs).padStart(2, "0")}:${String(mins).padStart(2, "0")}:${String(secs).padStart(2, "0")}`;

//check if finished
    if (totalSeconds <=0) {
        clearInterval(timerInterval);
        ending.style.display="block";
    }
    },  1000);

});

//Stop the countdown when the stop button is clicked
    stopBtn.addEventListener("click", ()=> {
        clearInterval(timerInterval);
    })
